(function() {
  //    FILE:EventListView
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'models/time/TimeModel', 'views/menu/MenuView', "views/project/FormProjectView", 'views/project/ProjectDetailView', 'models/project/ProjectModel', 'models/timereport/TimereportModel', 'views/timereport/TimereportDetailView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, TimeModel, MenuView, FormProjectView, ProjectDetailView, ProjectModel, TimereportModel, TimereportDetailView) {
    var ProjectListView;
    return ProjectListView = class ProjectListView extends Backbone.View {
      initialize(usr, projectCol, context, timereportsCol, obj, day, eventsCol) {
        this.usr = usr;
        this.projectCol = projectCol;
        this.context = context;
        this.timereportsCol = timereportsCol;
        this.obj = obj;
        this.day = day;
        this.eventsCol = eventsCol;
        this.projectCol.on('projectlist_updated', this.update_project_list, this);
        //@projectCol.on('projectlist_recent_updated',@update_project_recent_list,@)
        return this.tm = new TimeModel();
      }

      attributes() {
        return {
          'data-role': 'page',
          'data-name': 'ProjectListView'
        };
      }

      events() {
        return {
          'tap #id-btn-panel': 'btnPanelClicked',
          'tap #id-btn-back': 'btnBackClicked',
          'tap #id-ul-projectlist > li': 'projectClicked',
          'tap #id-ul-projectlist-recent > li': 'projectClicked',
          'tap .btn-submenu-projectlist': 'subMenuProjectListClicked',
          'tap #id-btn-add-project': 'btnAddProjectClicked',
          'keyup #id-input-search-project': 'inputSearchChanged',
          'change #id-input-search-project': 'inputSearchChanged',
          'pageshow': 'pageShown'
        };
      }

      render() {
        var ref, template;
        template = Handlebars.templates['ProjectListView'];
        this.$el.html(template({
          user: this.usr.toJSON(),
          context: this.context,
          canCreateProjects: this.usr.__can_create_projects()
        }));
        this.$el.attr('id', 'id-ProjectListView');
        if (this.context === 'ProjectsViewing' || (((ref = this.context) === 'AddBooking' || ref === 'Adhoc' || ref === 'AddTodo') && window.media_query_min_width(768))) {
          this.addSidePanel();
        }
        return this.$el;
      }

      //HANDLING OF SIDE PANEL AND NAVIGATION
      addSidePanel() {
        if (!MenuView) {
          MenuView = require("views/menu/MenuView");
        }
        this.panel = new MenuView(this.usr, this.obj);
        this.panel.render();
        return this.$el.append(this.panel.el);
      }

      subMenuProjectListClicked(event) {
        var btn, id;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        id = btn.attr('data-target');
        $('.subProjectListView').hide();
        return $(id).show();
      }

      btnPanelClicked(event) {
        return this.panel.btnPanelClicked(event);
      }

      update_project_list(col) {
        var projects, ul;
        this.$el.find('#id-spinner-all').hide();
        ul = $('#id-ul-projectlist');
        ul.empty();
        if (col) {
          projects = col.sort().toJSON();
        } else {
          projects = this.projectCol.sort().toJSON();
        }
        _.each(projects, function(p) {
          var li;
          li = `<li data-projectid=\"${p.projectID}\"><span class='header'> ${p.name} (${p.number})</span><span class='subheader1'>${p.contactCompanyName}</span><span class='fwi-arrow-right arrow-right'></span> </li>`;
          return ul.append(li);
        });
        ul.listview();
        return ul.listview('refresh');
      }

      update_project_recent_list() {
        var projects, ul;
        ul = $('#id-ul-projectlist-recent');
        ul.empty();
        projects = this.projectCol.get_recent_projects();
        _.each(projects, function(p) {
          var li;
          li = `<li data-projectid=\"${p.projectID}\"><span class='header'> ${p.name} (${p.number})</span><span class='subheader1'>${p.contactCompanyName}</span><span class='fwi-arrow-right arrow-right'></span> </li>`;
          return ul.append(li);
        });
        ul.listview();
        return ul.listview('refresh');
      }

      projectClicked(event) {
        var clientCompanyName, cur, iView, id, involvedObj, prj, prjName, prjObj, timeIn, timeOut, timereport, view;
        event.preventDefault();
        event.stopPropagation();
        cur = $(event.currentTarget);
        id = cur.attr('data-projectID');
        prjName = cur.find('.header').text();
        clientCompanyName = cur.find('.subheader1').text();
        //GET PROEJCT DETAILS
        prj = new ProjectModel();
        if (this.context === 'AddBooking') {
          iView = $.mobile.jqmNavigator.getViews().length - 2;
          view = $.mobile.jqmNavigator.getViews()[iView];
          prj.on('change', _.bind(view.addedBookingProject, this, view));
        //prj.on('project_booking_updated', _.bind(view.addedBookingProject,@,view))
        } else if (this.context === 'AddTodo') {
          iView = $.mobile.jqmNavigator.getViews().length - 2;
          view = $.mobile.jqmNavigator.getViews()[iView];
          prj.on('change', _.bind(view.addedTodoProject, this, view));
        } else if (this.context === 'Adhoc') {
          prjObj = {
            adhocProjectID: id,
            parentTitle: prjName,
            clientCompanyName: clientCompanyName,
            isAdhoc: 1,
            bookingID: '',
            day: this.day.format('YYYY-MM-DD')
          };
          prjObj.Involved = new Array();
          timeIn = this.usr.get('defaultEventStartTime');
          timeOut = this.usr.get('defaultEventStopTime');
          involvedObj = {
            'objectID': '',
            'involvedID': '',
            'type': '',
            'timeunitQuantityReported': '',
            'activityID': '',
            'noteReported': '',
            'timeInReported': timeIn,
            'timeOutReported': timeOut,
            'classID': '',
            'outTimeGoesIntoNextDay': '',
            'name': ''
          };
          if (this.obj) {
            involvedObj['objectID'] = this.obj.get('objectID');
            involvedObj['classID'] = this.obj.get('objectClassID');
            involvedObj['type'] = this.obj.get('objectType');
            involvedObj['name'] = this.obj.get('objectName');
          } else {
            //            objectClassID: "id201102221053500000002333,id201102251402320000000130,id200709230725210000000037,id201209111031000000000098"
            involvedObj['objectID'] = this.usr.get('usersObjectID');
            involvedObj['type'] = this.usr.get('usersObjectType');
            involvedObj['name'] = this.usr.get('usersFullName');
          }
          prjObj.Involved.push(involvedObj);
          timereport = new TimereportModel();
          timereport.collection = this.timereportsCol;
          timereport.init_adhoc_timereport(prjObj);
          //timereport.collection = @timereportsCol
          if (!TimereportDetailView) {
            TimereportDetailView = require('views/timereport/TimereportDetailView');
          }
          view = new TimereportDetailView(this.usr, timereport, this.timereportsCol, 'Adhoc', this.eventsCol, this.obj);
          $.mobile.jqmNavigator.replaceView(view, {
            transition: "none"
          });
        } else {
          //prj.get_project_booking(@usr,id)
          if (!ProjectDetailView) {
            ProjectDetailView = require("views/project/ProjectDetailView");
          }
          view = new ProjectDetailView(this.usr, prj, this.projectCol);
          $.mobile.jqmNavigator.pushView(view, {
            transition: "none"
          });
        }
        return prj.get_project_detail(this.usr, id);
      }

      inputSearchChanged(event) {
        var col, input, query;
        input = $(event.currentTarget);
        query = input.val();
        if (query.length >= 2) {
          col = this.projectCol.findByNameOrCompanyOrNumber(query);
          this.update_project_list(col);
        }
        //      else if query.length is 0
        //        @update_contact_list()
        if (query.length === 0) {
          return this.update_project_list();
        }
      }

      btnAddProjectClicked(event) {
        var view;
        event.preventDefault();
        event.stopPropagation();
        if (!FormProjectView) {
          FormProjectView = require("views/project/FormProjectView");
        }
        view = new FormProjectView(this.usr, this.projectCol);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: "none"
        });
      }

      btnBackClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

    };
  });

}).call(this);
